/* "@(#)$Id: e1432.h,v 1.296 1999/05/26 21:51:55 dhiller Exp $" */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This header file declares the functions provided by lib96sx.clb and
   by lib1432.a.  This header file should be included by downloaded
   e1432 code, and by any host program that uses the lib1432.a
   library. */

#ifndef	_E1432_H
#define	_E1432_H

#ifdef E1485_SOURCE
#include <spil_d.h>
#else
#include <limits.h>
#endif
#include "machType.h"

#if defined(MSDOS) || defined(_MSDOS) || defined(__MSDOS) || defined(__MSDOS__)
#define	EXPORT	__export __pascal
#else
#define	EXPORT
#endif

#ifdef __cplusplus
#define volatile

extern "C" {
#endif

/* Software characteristics */
#define	E1432_MODEL_CODE		0x201	/* E1432 ID */
#define	E1432_MODEL_CODE_MIN		0x200	/* E1432 ID */
#define	E1432_MODEL_CODE_MAX		0x20f	/* E1432 ID */
#define	E1432_MODEL_CODE_NOT_BOOTED	0x200	/* E1432 ID */
#define	E1432_MODEL_CODE_E1432		0x201	/* E1432 ID */
#define	E1432_MODEL_CODE_E1433		0x202	/* E1433 ID */
#define	E1432_MODEL_CODE_E1434		0x203	/* E1434 ID */
#define	E1432_MAN_ID			0xfff	/* HP ID */
#define	E1432_MODULES			255	/* max number of E1432s */
#define	E1432_CHANS			20	/* channels per module */
/* E1432_INPUT_CHANS must match subst/dervish.inc */
#define	E1432_INPUT_CHANS		16	/* max input chans per mod */
#define	E1432_SRC_CHANS			5	/* max src chans per mod */
#define	E1432_TACH_CHANS		2	/* max tach channels per mod */
/* E1432_NUM_SPANS_MAX must match subst/dervish.inc */
#define	E1432_NUM_SPANS_MAX		6	/* maximum number of spans */
/* E1432_204_NUM_SPANS_MAX must match subst/dervish.inc opt 204 branch */
#define	E1432_204_NUM_SPANS_MAX		11	/* maximum number of spans */
#define	E1432_SCAS			5	/* SCAs per module */
#define	E1432_ORDER_BLOCKSIZE_MAX	8192	/* order measure max blksize */
#define	E1432_FFT_BLOCKSIZE_MIN		64	/* min FFT blocksize */
#define	E1432_FFT_BLOCKSIZE_MAX		8192	/* max FFT blocksize */
#define E1432_VIRTUAL_TACH_START	(E1432_CHANS - E1432_TACH_CHANS)
#define	E1432_SICL_NAME_MAX		32	/* SICL interface name */
#define E1432_ORDER_CVT_SIZE            128  /* max points in one chan of CVT */

#define	E1432_CVT_DATA_OVLD		1000000.0f
#define	E1432_CVT_DATA_NONE		-1000000.0f

/* Length of serial number in e1432_hwconfig structure.  Don't
   change this, it is also used in the internal boot ROM calibration
   structure and must continue to match all boot ROMs in existence. */
#define	E1432_SERIAL_LENGTH		20

/* Hardware characteristics */
#define	E1432_ANALOG_DELAY		(11.925E-6) /* sec */
#define	E1432_AC_SETTLING_TIME		15.0	/* sec */
#define	E1432_AC_RANGING_TIME		2.0	/* sec */
#define	E1432_OVHD			2.189784 /* dB */
#define E1432_TACH_WRAP_COUNT		4294967296.0
#define	E1432_DRAM_SIZE_MAX		0x2000000L /* 32 MB */

/* Size of the raw tach buffer on the E1432 */
#define	E1432_TACH_RAW_SIZE		16384

/* SCA IDs */
#define	E1432_SCA_ID_UNKNOWN		-1    /* unknown whether SCA present */
#define	E1432_SCA_ID_IGNORE		0     /* disregard this SCA */
#define	E1432_SCA_ID_NONE		0x1f  /* no SCA present */
#define	E1432_SCA_ID_INPUT		0x18  /* undetermined input SCA */
#define	E1432_SCA_ID_SOURCE		0x19  /* undetermined source SCA */
#define	E1432_SCA_ID_TACH		4
#define	E1432_SCA_ID_CLARINET		6
#define	E1432_SCA_ID_VIBRATO		10
#define	E1432_SCA_ID_SONATA_A		12
#define	E1432_SCA_ID_SONATA_B		13
#define	E1432_SCA_ID_SONATA		E1432_SCA_ID_SONATA_A
#define	E1432_SCA_ID_CLARION		7

/* DRAM defines */
#define	E1432_DRAM_UNKNOWN		-1
#define	E1432_DRAM_IGNORE		0
#define	E1432_DRAM_4M			4
#define	E1432_DRAM_32M			32

/* Smart break-out box IDs */
/* The firmware currently assumes Charge BoBs have even IDs, and Mike
   BoBs have odd IDs. */
#define	E1432_BOB_ID_NONE		0
#define	E1432_BOB_ID_CHARGE_PROTO	0xfe
#define	E1432_BOB_ID_MIKE_PROTO		0xfd
#define	E1432_BOB_ID_CHARGE		0xfc
#define	E1432_BOB_ID_MIKE		0xfb
#define	E1432_BOB_ID_CHARGE2		0xfa
#define	E1432_BOB_ID_MIKE2		0xf9

/* Channel software characteristics */
#define	E1432_CHAN_TYPE_INPUT		0
#define	E1432_CHAN_TYPE_SOURCE		1
#define	E1432_CHAN_TYPE_TACH		2
#define	E1432_CHAN_TYPE_OTHER		3
#define	E1432_CHAN_TYPES		4

#define	E1432_INPUT_CHAN(n)		((E1432_CHAN_TYPE_INPUT <<\
					  E1432_CHAN_TYPE_SHIFT) | (n))
#define	E1432_SOURCE_CHAN(n)		((E1432_CHAN_TYPE_SOURCE <<\
					  E1432_CHAN_TYPE_SHIFT) | (n))
#define	E1432_TACH_CHAN(n)		((E1432_CHAN_TYPE_TACH <<\
					  E1432_CHAN_TYPE_SHIFT) | (n))
#define	E1432_CHAN_MASK			0xfff
#define	E1432_CHAN_TYPE_MASK		0x3000
#define	E1432_CHAN_TYPE_SHIFT		12

#ifdef	__DSP96K__
#define	REG(_s)		((void *) ((_s) >> 2))
#else
#define	REG(_s)		(_s)
#endif	/* !__DSP96K__ */

/* VXI Address offsets of registers from module base address */
/* VXI Configuration registers */
#define	E1432_ID_REG			REG(0x000) /* VXI, Read */
#define	E1432_LOGICAL_ADDRESS_REG	REG(0x000) /* VXI, Write */
#define	E1432_DEVICE_TYPE_REG		REG(0x002) /* VXI */
#define	E1432_STATUS_REG		REG(0x004) /* VXI, Read */
#define	E1432_CONTROL_REG		REG(0x004) /* VXI, Write */
#define	E1432_OFFSET_REG		REG(0x006) /* VXI */
#define	E1432_PORT_CTL_REG		REG(0x008) /* VXI */
#define	E1432_PAGE_MAP_REG		REG(0x00a) /* E1432 16 */
#define	E1432_IRQ_CONFIG_REG		REG(0x00c) /* E1432 16 */
#define	E1432_IRQ_STATUS_REG		REG(0x00e) /* E1432 16, Read */
#define	E1432_IRQ_RESET_REG		REG(0x00e) /* E1432 16, Write */
#define	E1432_IRQ_STATUS2_REG		REG(0x010)
#define	E1432_MEAS_STATE_REG		REG(0x014)
#define	E1432_FIFO_DATA_REG		REG(0x018)
#define	E1432_FIFO_COUNT_REG		REG(0x01e)

/* These is now part of the API, so they shouldn't be moved */
#define	E1432_MEAS_WATCHDOG_REG		REG(0x088)
#define E1432_CHAN_DATA_MASK_REG        REG(0x708)
#define E1432_SRC_STATUS_REG            REG(0x8f0)

/* Parameter limits and values */

/* e1432_set_active */
/* e1432_set_trigger_channel */
#define	E1432_CHANNEL_ON		420
#define	E1432_CHANNEL_OFF		421
#define	E1432_CHANNEL_MAYBE		422
#define	E1432_CHANNEL_PRE_ARM		423
#define	E1432_ACTIVE_DEF		E1432_CHANNEL_MAYBE
#define	E1432_TRIGGER_CHANNEL_DEF	E1432_CHANNEL_OFF

/* e1432_set_anti_alias_analog */
#define	E1432_ANTI_ALIAS_ANALOG_ON	112
#define	E1432_ANTI_ALIAS_ANALOG_OFF	113
#define	E1432_ANTI_ALIAS_ANALOG_DEF	E1432_ANTI_ALIAS_ANALOG_ON

/* e1432_set_anti_alias_digital */
#define	E1432_ANTI_ALIAS_DIGITAL_ON	615
#define	E1432_ANTI_ALIAS_DIGITAL_OFF	616
#define	E1432_ANTI_ALIAS_DIGITAL_BES	617
#define	E1432_ANTI_ALIAS_DIGITAL_DEF	E1432_ANTI_ALIAS_DIGITAL_ON

/* e1432_set_append_status */
#define	E1432_APPEND_STATUS_OFF		310
#define	E1432_APPEND_STATUS_ON		311
#define	E1432_APPEND_STATUS_DEF		E1432_APPEND_STATUS_OFF

/* e1432_set_arm_mode */
/* e1432_set_pre_arm_mode */
#define	E1432_AUTO_ARM_CONTINUOUS	429
#define	E1432_MANUAL_ARM		430
#define	E1432_AUTO_ARM			431
#define E1432_ARM_RPM_RUNUP		432
#define E1432_ARM_RPM_RUNDOWN		433
#define E1432_ARM_RPM_DELTA		434
#define	E1432_ARM_EXTERNAL		435	/* pre_arm only */
#define E1432_ARM_TIME			436
#define E1432_ARM_TIME_OR_RPM		437
#define	E1432_ARM_DEF			E1432_AUTO_ARM

/* e1432_set_arm_time_interval */
#define E1432_ARM_TIME_INTERVAL_MIN	0.0001f
#define E1432_ARM_TIME_INTERVAL_MAX	2000000000.0f
#define E1432_ARM_TIME_INTERVAL_DEF	1.0f

/* e1432_set_auto_group_meas */
#define	E1432_AUTO_GROUP_MEAS_ON	242
#define	E1432_AUTO_GROUP_MEAS_OFF	243
#define	E1432_AUTO_GROUP_MEAS_DEF	E1432_AUTO_GROUP_MEAS_ON

/* e1432_set_auto_range_mode */
#define	E1432_AUTO_RANGE_MODE_UP	0x1
#define	E1432_AUTO_RANGE_MODE_DOWN	0x2
#define	E1432_AUTO_RANGE_MODE_DEF	(E1432_AUTO_RANGE_MODE_UP |\
					 E1432_AUTO_RANGE_MODE_DOWN)

/* e1432_set_auto_trigger */
#define	E1432_MANUAL_TRIGGER		440
#define	E1432_TACH_EDGE_TRIGGER		440
#define	E1432_AUTO_TRIGGER		441
#define	E1432_TRIGGER_DEF		E1432_AUTO_TRIGGER

/* e1432_set_avg_mode */
/* These values must match subst/dervish.inc */
#define E1432_AVG_NONE       		700
#define E1432_AVG_RMS        		701
#define E1432_AVG_LIN        		702
#define E1432_AVG_EXPO    		703
#define E1432_AVG_PEAK       		704
#define E1432_AVG_CMPLX_EXPO		705
#define E1432_AVG_DEF        		E1432_AVG_NONE

/* e1432_set_avg_number */
#define E1432_AVG_NUMBER_MIN		0
#define E1432_AVG_NUMBER_MAX		0x7FFFFFFF
#define E1432_AVG_NUMBER_DEF		10

/* e1432_set_avg_update */
#define E1432_AVG_UPDATE_MIN		1
#define E1432_AVG_UPDATE_MAX		0x7FFFFFFF
#define E1432_AVG_UPDATE_DEF		10

/* e1432_set_avg_weight */
#define E1432_AVG_WEIGHT_MIN		1.0f
#define E1432_AVG_WEIGHT_MAX		1.0E20f
#define E1432_AVG_WEIGHT_DEF		E1432_AVG_WEIGHT_MIN

/* e1432_set_blocksize */
#define	E1432_BLOCKSIZE_MIN		1	/* 1 sample */
#define	E1432_BLOCKSIZE_MAX		((E1432_DRAM_SIZE_MAX >> 1L) - 1L)
#define	E1432_BLOCKSIZE_DEF		1024

/* e1432_set_cal_dac */
#define	E1432_CAL_DAC_MIN		-2048
#define E1432_CAL_DAC_MAX 		2048	/* Gets rounded to 2047 */
#define E1432_CAL_DAC_DEF 		0

/* e1432_set_cal_voltage */
#define	E1432_CAL_VOLTAGE_MIN		-15.0f
#define E1432_CAL_VOLTAGE_MAX 		15.0f
#define E1432_CAL_VOLTAGE_DEF 		0.0f

/* e1432_set_calc_data */
/* keep these in this order !!!!! */
#define E1432_DATA_TIME 		724
#define E1432_DATA_FREQ 		725
#define E1432_DATA_RESAMP_TIME 		726
#define E1432_DATA_ORDER		727
#define E1432_DATA_CORR_FREQ 		728
#define	E1432_DATA_FIR			729
#define	E1432_DATA_USER1		730
#define	E1432_DATA_USER2		731
#define	E1432_DATA_OCTAVE		E1432_DATA_USER1
#define E1432_DATA_DEF			E1432_DATA_TIME

/* e1432_set_calin */
#define E1432_CALIN_OPEN		510
#define E1432_CALIN_GROUND		511
#define E1432_CALIN_DC_HI		512
#define E1432_CALIN_DC_LO		513
#define E1432_CALIN_SUMBUS		514
#define E1432_CALIN_CALOUT		515
#define	E1432_CALIN_SUMBUS_TACH		516
#define	E1432_CALIN_DEF			E1432_CALIN_GROUND

/* e1432_set_center_freq */
#define	E1432_CENTER_FREQ_MIN		0.0f
#define	E1432_CENTER_FREQ_MAX		128000.0f
#define	E1432_CENTER_FREQ_DEF		2000.0f

/* e1432_set_clock_freq */
#define	E1432_CLOCK_FREQ_MIN		40960.0f
#define	E1432_CLOCK_FREQ_MAX		200000.0f
#define	E1432_CLOCK_FREQ_DEF		51200.0f

/* e1432_set_clock_master */
#define	E1432_MASTER_CLOCK_ON		240
#define	E1432_MASTER_CLOCK_OFF		241
#define	E1432_MASTER_CLOCK_DEF		E1432_MASTER_CLOCK_OFF

/* e1432_set_clock_source */
#define	E1432_CLOCK_VXI_DEC_3		204
#define	E1432_CLOCK_SOURCE_EXTERNAL	206
#define	E1432_CLOCK_SOURCE_EXTERNALN	207
#define	E1432_CLOCK_SOURCE_INTERNAL	208
#define	E1432_CLOCK_SOURCE_VXI		209
#define	E1432_CLOCK_SOURCE_INT_VXI10	210
#define	E1432_CLOCK_SOURCE_DEF		E1432_CLOCK_SOURCE_INTERNAL

/* e1432_set_coupling */
#define	E1432_COUPLING_AC		100
#define	E1432_COUPLING_DC		101
#define	E1432_COUPLING_AC_BOB_HP	102
#define	E1432_COUPLING_DC_BOB_HP	103
#define	E1432_COUPLING_DEF		E1432_COUPLING_DC

/* e1432_get_current_value */
#define	E1432_CURRENT_VAL_PEAK		589
#define	E1432_CURRENT_VAL_RMS		599
#define	E1432_CURRENT_VAL_FIFO_AVAIL	600

/* e1432_set_data_mode */
#define	E1432_BLOCK_MODE		340
#define	E1432_CONTINUOUS_MODE		341
#define	E1432_DATA_MODE_OVERLAP_BLOCK	342
#define	E1432_DATA_MODE_OVERLAP_FREERUN	343
#define	E1432_DATA_MODE_DEF		E1432_DATA_MODE_OVERLAP_BLOCK

/* e1432_set_data_port */
#define	E1432_SEND_PORT_VME		300
#define	E1432_SEND_PORT_LBUS		301
#define	E1432_SEND_PORT_LBUS_EAVES	302
#define	E1432_SEND_PORT_DEF		E1432_SEND_PORT_VME

/* e1432_set_data_size */
#define	E1432_DATA_SIZE_NONE		330
#define	E1432_DATA_SIZE_16		331
#define	E1432_DATA_SIZE_32		332
#define	E1432_DATA_SIZE_32_SERV		333
#define	E1432_DATA_SIZE_FLOAT32		334
#define	E1432_DATA_SIZE_FRACT		758		/* internal use only */
#define	E1432_DATA_SIZE_FLOAT64		759		/* internal use only */
#define	E1432_DATA_SIZE_DEF		E1432_DATA_SIZE_16

#define	E1432_DATA_SIZE_32_MASK		0xffffff00UL

/* e1432_set_decimation_bandwidth */
#define	E1432_DECIMATION_MIN		0
#define	E1432_DECIMATION_MAX		16
#define	E1432_DECIMATION_DEF		0

/* e1432_set_decimation_output */
#define	E1432_ONEPASS			620
#define	E1432_MULTIPASS			621
#define	E1432_DECIMATION_OUTPUT_DEF	E1432_ONEPASS

/* e1432_set_decimation_oversample */
#define	E1432_DECIMATION_OVERSAMPLE_OFF	630
#define	E1432_DECIMATION_OVERSAMPLE_ON	631
#define	E1432_DECIMATION_OVERSAMPLE_DEF	E1432_DECIMATION_OVERSAMPLE_OFF

/* e1432_set_decimation_undersamp */
#define	E1432_DECIMATION_UNDERSAMP_MIN	1
#define	E1432_DECIMATION_UNDERSAMP_MAX	16
#define	E1432_DECIMATION_UNDERSAMP_DEF	E1432_DECIMATION_UNDERSAMP_MIN

/* e1432_set_delta_order */
#define E1432_DELTA_ORDER_MIN		0.005f
#define E1432_DELTA_ORDER_MAX		1.0f
#define E1432_DELTA_ORDER_DEF		0.1f

/* e1432_set_enable */
#define	E1432_ENABLE_TYPE_TIME		270
#define	E1432_ENABLE_TYPE_FREQ		271
#define	E1432_ENABLE_TYPE_RESAMPLE	272
#define	E1432_ENABLE_TYPE_ORDER		273
#define	E1432_ENABLE_TYPE_USER1		274
#define	E1432_ENABLE_TYPE_USER2		275
#define	E1432_ENABLE_TYPE_OCTAVE	E1432_ENABLE_TYPE_USER1

#define	E1432_ENABLE_ON			280
#define	E1432_ENABLE_OFF		281
#define	E1432_ENABLE_DEF		E1432_ENABLE_ON

/* e1432_set_fifo_size */
#define	E1432_FIFO_SIZE_MIN		0	/* Zero means use max */
#define	E1432_FIFO_SIZE_MAX		E1432_BLOCKSIZE_MAX
#define	E1432_FIFO_SIZE_DEF		0

/* e1432_set_filter_settling_time */
#define	E1432_FILTER_SETTLING_MIN	0.0f
#define	E1432_FILTER_SETTLING_MAX	10000.0f
#define	E1432_FILTER_SETTLING_DEF	E1432_FILTER_SETTLING_MIN

/* e1432_get_group_info */
#define	E1432_GROUP_INFO_NUM_MODULES	230
#define	E1432_GROUP_INFO_LIST_MODULES	231
#define	E1432_GROUP_INFO_NUM_CHANNELS	232
#define	E1432_GROUP_INFO_LIST_CHANNELS	233
#define	E1432_GROUP_INFO_NUM_INPUTS	234
#define	E1432_GROUP_INFO_LIST_INPUTS	235
#define	E1432_GROUP_INFO_NUM_SOURCES	236
#define	E1432_GROUP_INFO_LIST_SOURCE	237
#define	E1432_GROUP_INFO_NUM_TACHS	238
#define	E1432_GROUP_INFO_LIST_TACHS	239

/* e1432_set_hpf_span */
#define	E1432_HPF_SPAN_MIN		62.5f	/* Hz */
#define E1432_HPF_SPAN_MAX              20000.0f /* Hz */
#define E1432_HPF_SPAN_DEF              20000.0f /* Hz */

/* e1432_set_input_high */
#define	E1432_INPUT_HIGH_NORMAL		120
#define	E1432_INPUT_HIGH_CALIN		121
#define	E1432_INPUT_HIGH_GROUNDED	122
#define	E1432_INPUT_HIGH_CALOUT		123
#define	E1432_INPUT_HIGH_BOB_CALIN	124
#define	E1432_INPUT_HIGH_DEF		E1432_INPUT_HIGH_NORMAL
/* Obsolete E1431-compatible names: */
#define	E1432_INPUT_SOURCE_BNC		E1432_INPUT_HIGH_NORMAL
#define	E1432_INPUT_SOURCE_SUMBUS	E1432_INPUT_HIGH_CALIN
#define	E1432_INPUT_SOURCE_ZERO		E1432_INPUT_HIGH_GROUNDED

/* e1432_set_input_low */
#define E1432_INPUT_LOW_GROUNDED	140
#define E1432_INPUT_LOW_FLOATING	141
#define	E1432_INPUT_LOW_DEF		E1432_INPUT_LOW_FLOATING
/* Obsolete E1431-compatible names: */
#define E1432_INPUT_GROUNDED		E1432_INPUT_LOW_GROUNDED
#define E1432_INPUT_FLOATING		E1432_INPUT_LOW_FLOATING

/* e1432_set_input_mode */
#define	E1432_INPUT_MODE_VOLT		130
#define	E1432_INPUT_MODE_ICP		131
#define	E1432_INPUT_MODE_CHARGE		132
#define	E1432_INPUT_MODE_MIC		133
#define	E1432_INPUT_MODE_MIC_200V	134
#define	E1432_INPUT_MODE_DEF		E1432_INPUT_MODE_VOLT

/* e1432_set_internal_debug */
#define	E1432_INTERNAL_DEBUG_MIN	LONG_MIN
#define	E1432_INTERNAL_DEBUG_MAX	LONG_MAX
#define	E1432_INTERNAL_DEBUG_DEF	0

/* e1432_set_interrupt_mask */
/* See bits in E1432_IRQ_CONFIG_REG below */

/* e1432_set_interrupt_priority */
/* See bits in E1432_IRQ_CONFIG_REG below */

/* e1432_set_lbus_mode */
#define	E1432_LBUS_MODE_GENERATE	302
#define	E1432_LBUS_MODE_PIPE		303
#define	E1432_LBUS_MODE_INSERT		304
#define	E1432_LBUS_MODE_APPEND		305
#define	E1432_LBUS_MODE_CONSUME		306
#define	E1432_LBUS_MODE_DEF		E1432_LBUS_MODE_PIPE

/* e1432_reset_lbus, e1432_get_lbus_reset */
#define	E1432_RESET_LBUS_ON		306
#define	E1432_RESET_LBUS_OFF		307
#define	E1432_RESET_LBUS_DEF		E1432_RESET_LBUS_OFF

/* e1432_set_max_order */
#define E1432_MAX_ORDER_MIN		1.0f
#define E1432_MAX_ORDER_MAX		500.0f
#define E1432_MAX_ORDER_DEF		10.0f

/* e1432_set_meas_time_length */
#define E1432_MEAS_TIME_LENGTH_MIN	0.0f
#define E1432_MEAS_TIME_LENGTH_MAX	2000000000.0f
#define E1432_MEAS_TIME_LENGTH_DEF	0.0f	/* Run forever */

/* e1432_set_meas_type */
/* not fully implemented, reserve values 380-389 */
#define	E1432_MEAS_TYPE_OCTAVE		E1432_OCTAVE_MEAS_ON
#define	E1432_MEAS_TYPE_OTHER		E1432_OCTAVE_MEAS_OFF
#define	E1432_MEAS_TYPE_DEF		E1432_OCTAVE_MEAS_OFF

/* e1432_set_mmf_delay */
#define	E1432_MMF_DELAY_MIN		0
#define	E1432_MMF_DELAY_MAX		LONG_MAX
#define	E1432_MMF_DELAY_DEF		0

/* e1432_set_multi_sync */
#define	E1432_MULTI_SYNC_ON		220
#define	E1432_MULTI_SYNC_OFF		221
#define	E1432_MULTI_SYNC_VXD		222
#define	E1432_MULTI_SYNC_VXD_MIN	223
#define	E1432_MULTI_SYNC_DEF		E1432_MULTI_SYNC_OFF
/* Obsolete E1431-compatible names: */
#define	E1432_SYSTEM_SYNC_ON		E1432_MULTI_SYNC_ON
#define	E1432_SYSTEM_SYNC_OFF		E1432_MULTI_SYNC_OFF

/* e1432_set_octave_avg_mode */
#define	E1432_OCTAVE_AVG_MODE_EXP	760
#define	E1432_OCTAVE_AVG_MODE_LIN	761
#define	E1432_OCTAVE_AVG_MODE_DEF	E1432_OCTAVE_AVG_MODE_EXP

/* e1432_octave_ctl */
#define	E1432_OCTAVE_CTL_STOP		770
#define	E1432_OCTAVE_CTL_RESTART	771
#define	E1432_OCTAVE_CTL_CONTINUE	772

/* e1432_set_octave_hold_mode */
#define	E1432_OCTAVE_HOLD_MODE_OFF	765
#define	E1432_OCTAVE_HOLD_MODE_MAX	766
#define	E1432_OCTAVE_HOLD_MODE_MIN	767
#define	E1432_OCTAVE_HOLD_MODE_DEF	E1432_OCTAVE_HOLD_MODE_OFF

/* e1432_set_octave_int_time */
#define	E1432_OCTAVE_INT_TIME_MIN	1.953125e-3f
#define	E1432_OCTAVE_INT_TIME_MAX	10000.0f
#define	E1432_OCTAVE_INT_TIME_DEF	1.0f
#define	E1432_OCTAVE_INT_TIME_STEP	2.0f	/* steps in factors of 2 */

/* e1432_set_octave_meas */
/* reserve 380-389, to facilitate migration to e1432_set_meas_type */
#define	E1432_OCTAVE_MEAS_ON		386
#define	E1432_OCTAVE_MEAS_OFF		389
#define	E1432_OCTAVE_MEAS_DEF		E1432_OCTAVE_MEAS_OFF

/* e1432_set_octave_mode */
/* #define	E1432_OCTAVE_MODE_OFF	750	defunct */
#define	E1432_OCTAVE_MODE_FULL		751
#define	E1432_OCTAVE_MODE_THIRD		752
#define	E1432_OCTAVE_MODE_DEF		E1432_OCTAVE_MODE_THIRD

/* e1432_set_octave_start_freq */
#define	E1432_OCTAVE_START_FREQ_MIN	3.15f
#define	E1432_OCTAVE_START_FREQ_MAX	E1432_OCTAVE_STOP_FREQ_MAX
#define	E1432_OCTAVE_START_FREQ_DEF	E1432_OCTAVE_START_FREQ_MIN

/* e1432_set_octave_stop_freq */
#define	E1432_OCTAVE_STOP_FREQ_MIN	E1432_OCTAVE_START_FREQ_MIN
#define	E1432_OCTAVE_STOP_FREQ_MAX	20.0e3f
#define	E1432_OCTAVE_STOP_FREQ_DEF	E1432_OCTAVE_STOP_FREQ_MAX

/* e1432_set_octave_time_const */
#define	E1432_OCTAVE_TIME_CONST_MIN	7.8125e-3f
#define	E1432_OCTAVE_TIME_CONST_MAX	16.0f
#define	E1432_OCTAVE_TIME_CONST_DEF	.125f
#define	E1432_OCTAVE_TIME_CONST_STEP	2.0f    /* steps in factors of 2 */

/* e1432_set_octave_time_step */
#define	E1432_OCTAVE_TIME_STEP_MIN	1.953125e-3f
#define	E1432_OCTAVE_TIME_STEP_MAX	10000.0f
#define	E1432_OCTAVE_TIME_STEP_DEF	.125f
#define	E1432_OCTAVE_TIME_STEP_STEP	2.0f    /* steps in factors of 2 */

/* e1432_set_overlap */
#define	E1432_OVERLAP_MIN		(-((E1432_DRAM_SIZE_MAX >> 1L) - 1L))
#define	E1432_OVERLAP_MAX		(E1432_BLOCKSIZE_MAX - 1L)
#define	E1432_OVERLAP_DEF		0

/* e1432_set_peak_decay_time exponential decay time constant */
#define E1432_PEAK_DECAY_TIME_MIN	0.0f /* Sec */
#define E1432_PEAK_DECAY_TIME_MAX	40.0f /* Sec */
#define E1432_PEAK_DECAY_TIME_DEF	1.5f /* Sec */

/* e1432_set_peak_hold_time */
#define E1432_PEAK_HOLD_TIME_MIN        0.0f /* Sec */
#define E1432_PEAK_HOLD_TIME_MAX        40.0f /* Sec */
#define E1432_PEAK_HOLD_TIME_DEF        1.0f /* Sec */

/* e1432_set_peak_mode */
#define E1432_PEAK_MODE_OFF		580
#define E1432_PEAK_MODE_BLOCK		581
#define E1432_PEAK_MODE_FILT		582
#define E1432_PEAK_MODE_ON		E1432_PEAK_MODE_BLOCK /* old enum */
#define E1432_PEAK_MODE_DEF		E1432_PEAK_MODE_OFF
/* E1432_CURRENT_VAL_PEAK defined up with e1432_get_current_value */

/* e1432_set_peak_span */
#define	E1432_PEAK_SPAN_MIN		0.024f	/* Hz */
#define E1432_PEAK_SPAN_MAX             20000.0f /* Hz */
#define E1432_PEAK_SPAN_DEF             20000.0f /* Hz */

/* e1432_set_pre_arm_mode */
/* See e1432_set_arm_mode above */

/* e1432_set_pre_arm_rpm */
/* ? */

/* e1432_set_ramp */
#define	E1432_RAMP_ON			625
#define	E1432_RAMP_OFF			626
#define	E1432_RAMP_DEF			E1432_RAMP_OFF

/* e1432_set_rms_avg_time (exponential average decay time constant) */
#define E1432_RMS_AVG_TIME_MIN		0.0f /* Sec */
#define E1432_RMS_AVG_TIME_MAX		60.0f /* Sec */
#define E1432_RMS_AVG_TIME_DEF		1.0f /* Sec */

/* e1432_set_rms_decay_time (exponential decay time constant) */
#define E1432_RMS_DECAY_TIME_MIN        0.0f /* Sec */
#define E1432_RMS_DECAY_TIME_MAX        60.0f /* Sec */
#define E1432_RMS_DECAY_TIME_DEF        0.0f /* Sec */

/* e1432_set_rms_mode */
#define E1432_RMS_MODE_OFF		590
#define E1432_RMS_MODE_BLOCK		591
#define E1432_RMS_MODE_FILT		592
#define E1432_RMS_MODE_BLOCK_ONLY	593	/* unsupported */
#define E1432_RMS_MODE_ON		E1432_RMS_MODE_BLOCK /* old enum */
#define E1432_RMS_MODE_DEF		E1432_RMS_MODE_OFF
/* E1432_CURRENT_VAL_RMS defined up with e1432_get_current_value */

/* e1432_set_rms_span */
#define	E1432_RMS_SPAN_MIN		0.024f	/* Hz */
#define E1432_RMS_SPAN_MAX              20000.0f /* Hz */
#define E1432_RMS_SPAN_DEF              20000.0f /* Hz */

/* e1432_set_sample_mode */
#define E1432_RESAMP_NORMAL		720
#define E1432_RESAMP_AT_TACH		721
#define E1432_RESAMP_DEF		E1432_RESAMP_NORMAL

/* e1432_set_source_cola */
#define E1432_SOURCE_COLA_OFF		180
#define	E1432_SOURCE_COLA_ON		181
#define	E1432_SOURCE_COLA_DRPEPPER	182
#define	E1432_SOURCE_COLA_DEF		E1432_SOURCE_COLA_OFF

/* e1432_set_source_mode */
#define	E1432_SOURCE_MODE_SINE		170
#define	E1432_SOURCE_MODE_BSINE		171
#define	E1432_SOURCE_MODE_RAND		172
#define	E1432_SOURCE_MODE_BRAND		173
#define	E1432_SOURCE_MODE_RANDZ		174
#define	E1432_SOURCE_MODE_BRANDZ	175
#define	E1432_SOURCE_MODE_ARB		176
#define	E1432_SOURCE_MODE_BARB		177
#define	E1432_SOURCE_MODE_DNLD		178
#define	E1432_SOURCE_MODE_BDNLD		179
#define	E1432_SOURCE_MODE_USR		180
#define	E1432_SOURCE_MODE_BUSR		181
#define	E1432_SOURCE_MODE_CLR		182
#define	E1432_SOURCE_MODE_MSINE		183
#define	E1432_SOURCE_MODE_PRAND		184
#define	E1432_SOURCE_MODE_BPRAND	185
#define	E1432_SOURCE_MODE_PRANDZ	186
#define	E1432_SOURCE_MODE_BPRANDZ	187
#define	E1432_SOURCE_MODE_ARB_ROFF	188
#define	E1432_SOURCE_MODE_BARB_ROFF	189
#define	E1432_SOURCE_MODE_DEF		E1432_SOURCE_MODE_SINE

/* e1432_set_source_output */
#define	E1432_SOURCE_OUTPUT_NORMAL	700
#define	E1432_SOURCE_OUTPUT_GROUNDED	701
#define	E1432_SOURCE_OUTPUT_OPEN	702
#define	E1432_SOURCE_OUTPUT_CAL		703
#define	E1432_SOURCE_OUTPUT_MULTI	704
#define	E1432_SOURCE_OUTPUT_DEF		E1432_SOURCE_OUTPUT_NORMAL

/* e1432_set_source_sum */
#define	E1432_SOURCE_SUM_OFF		190
#define	E1432_SOURCE_SUM_ON		191
#define	E1432_SOURCE_SUM_DEF		E1432_SOURCE_SUM_OFF

/* e1432_set_span */
#define	E1432_SPAN_MIN			0.024f	/* Hz */
#define	E1432_SPAN_MAX			78125.0f /* Hz */
#define	E1432_SPAN_DEF			20000.0f

/* e1432_set_srcbuffer_init */
#define E1432_SRCBUFFER_INIT_EMPTY	1
#define E1432_SRCBUFFER_INIT_RESET	2
#define E1432_SRCBUFFER_INIT_XFER	3
#define E1432_SRCBUFFER_INIT_DEF	E1432_SRCBUFFER_INIT_EMPTY

/* e1432_set_srcbuffer_mode */
#define E1432_SRCBUFFER_CONTINUOUS	1
#define E1432_SRCBUFFER_PERIODIC_AB	2
#define E1432_SRCBUFFER_PERIODIC_A	4
#define E1432_SRCBUFFER_SWITCHEDAUTO	8
#define E1432_SRCBUFFER_SWITCHEDCMD	16
#define	E1432_SRCBUFFER_ONESHOT		32
#define E1432_SRCBUFFER_MODE_DEF	E1432_SRCBUFFER_PERIODIC_A

/* e1432_set_srcparm_mode */
#define E1432_SRCPARM_MODE_DEFR		0x000000L
#define E1432_SRCPARM_MODE_IMMED	0xc00000L
#define E1432_SRCPARM_MODE_DEF		E1432_SRCPARM_MODE_IMMED

/* e1432_update_srcparm */
#define E1432_SRCPARM_UPDATE_IMMED		0xc00000L
#define E1432_SRCPARM_UPDATE_XING		0xa00000L
#define E1432_SRCPARM_UPDATE_TRGIN		0x900000L
#define E1432_SRCPARM_UPDATE_IMMEDTRGOUT	0xc80000L
#define E1432_SRCPARM_UPDATE_XINGTRGOUT		0xa80000L

/* e1432_set_srcoff_mode */
#define E1432_SRCOFF_MODE_RAMP		0
#define E1432_SRCOFF_MODE_IMMED		1
#define E1432_SRCOFF_MODE_DEF		E1432_SRCOFF_MODE_RAMP

/* e1432_set_sumbus */
#define E1432_SUMBUS_OFF		520
#define E1432_SUMBUS_CALOUT		521
#define	E1432_SUMBUS_DEF		E1432_SUMBUS_OFF

/* e1432_set_tach_irq_number */
#define E1432_TACH_IRQ_NUMBER_MIN	1
#define E1432_TACH_IRQ_NUMBER_MAX	E1432_TACH_RAW_SIZE / 4
#define E1432_TACH_IRQ_NUMBER_DEF	64

/* e1432_set_trigger_channel */
/* See e1432_set_active above */

/* e1432_set_trigger_delay */
#define	E1432_TRIG_DELAY_MIN		(-((E1432_DRAM_SIZE_MAX >> 1L) - 1L))
#define	E1432_TRIG_DELAY_MAX		((E1432_DRAM_SIZE_MAX >> 1L) - 1L)
#define	E1432_TRIG_DELAY_DEF		0

/* e1432_set_trigger_ext */
#define	E1432_TRIGGER_EXT_OFF		470
#define	E1432_TRIGGER_EXT_POS		471
#define	E1432_TRIGGER_EXT_NEG		472
#define	E1432_TRIGGER_EXT_PREARM_POS	473
#define	E1432_TRIGGER_EXT_PREARM_NEG	474
#define	E1432_TRIGGER_EXT_DEF		E1432_TRIGGER_EXT_OFF

/* e1432_set_trigger_level */
#define	E1432_TRIGGER_LEVEL_LOWER	416
#define	E1432_TRIGGER_LEVEL_UPPER	417

/* e1432_set_trigger_master */
#define	E1432_TRIGGER_MASTER_OFF	450
#define	E1432_TRIGGER_SLAVE		451
#define	E1432_TRIGGER_MASTER_ON		452
#define	E1432_TRIGGER_MASTER_DEF	E1432_TRIGGER_MASTER_OFF

/* e1432_set_trigger_mode */
#define	E1432_TRIGGER_MODE_LEVEL	414
#define	E1432_TRIGGER_MODE_BOUND	415
#define	E1432_TRIGGER_MODE_DEF		E1432_TRIGGER_MODE_LEVEL

/* e1432_set_trigger_slope */
#define	E1432_TRIGGER_SLOPE_POS		410
#define	E1432_TRIGGER_SLOPE_NEG		411
#define	E1432_TRIGGER_SLOPE_DEF		E1432_TRIGGER_SLOPE_POS

/* e1432_set_triggers_per_arm */
#define	E1432_TRIGGERS_PER_ARM_MIN	0	/* 0 means infinite */
#define	E1432_TRIGGERS_PER_ARM_MAX	LONG_MAX
#define	E1432_TRIGGERS_PER_ARM_DEF	1

/* e1432_set_ttltrg_xxx */
#define	E1432_TTLTRG_0			261
#define	E1432_TTLTRG_1			262
#define	E1432_TTLTRG_2			263
#define	E1432_TTLTRG_3			264
#define	E1432_TTLTRG_4			265
#define	E1432_TTLTRG_5			266
#define	E1432_TTLTRG_6			267
#define	E1432_TTLTRG_7			268
#define	E1432_TTLTRG_CLOCK_DEF		E1432_TTLTRG_1
#define	E1432_TTLTRG_GCLOCK_DEF		E1432_TTLTRG_1
#define	E1432_TTLTRG_SATRG_DEF		E1432_TTLTRG_0
#define	E1432_TTLTRG_TRIGGER_DEF	E1432_TTLTRG_0

/* e1432_set_ttltrg_lines */
#define	E1432_TTLTRG_01			250
#define	E1432_TTLTRG_23			251
#define	E1432_TTLTRG_45			252
#define	E1432_TTLTRG_67			253

/* e1432_set_user_decimation */
#define	E1432_USER_DECIMATION_MIN	1		/* no decimation */
#define	E1432_USER_DECIMATION_MAX	((E1432_DRAM_SIZE_MAX >> 1L) - 1L)
#define	E1432_USER_DECIMATION_DEF	1

/* e1432_set_user_frames_per_block */
#define	E1432_USER_FRAMES_PER_BLOCK_MIN	1	/* blocksize = frame_length */
#define	E1432_USER_FRAMES_PER_BLOCK_MAX	((E1432_DRAM_SIZE_MAX >> 1L) - 1L)
#define	E1432_USER_FRAMES_PER_BLOCK_DEF	1

/* e1432_set_weighting */
#define	E1432_WEIGHTING_OFF		105
#define	E1432_WEIGHTING_A		106
#define	E1432_WEIGHTING_B		107
#define	E1432_WEIGHTING_C		108
#define	E1432_WEIGHTING_DEF		E1432_WEIGHTING_OFF

/* e1432_set_window */
#define E1432_WINDOW_UNIFORM 		710
#define E1432_WINDOW_HANNING 		711
#define E1432_WINDOW_FLATTOP 		712
#define E1432_WINDOW_USER1   		713
#define E1432_WINDOW_USER2   		714
#define E1432_WINDOW_DEF		E1432_WINDOW_UNIFORM
#define E1432_WINDOW_SIZE_MAX		8192

/* e1432_set_xfer_size */
#define	E1432_XFER_SIZE_MIN		0
#define	E1432_XFER_SIZE_MAX		E1432_BLOCKSIZE_MAX
#define	E1432_XFER_SIZE_DEF		0

/* e1432_set_zoom */
#define	E1432_ZOOM_ON			622
#define	E1432_ZOOM_OFF			623
#define	E1432_ZOOM_DEF			E1432_ZOOM_OFF

/* Other non-parameter defines */

/* e1432_get_src_arbstates, srcbuf_state_ */
#define E1432_SRCBUF_RDY		0x00000000L
#define E1432_SRCBUF_AVAIL		0x00000001L
#define E1432_SRCBUF_FULL		0x00000002L

/* e1432_get_src_arbstates, xfrbuf_wds */
#define E1432_SRC_XFRBUF_WDS_EMPTY	0

/* e1432_install */
#define	E1432_INSTALL_FAST		0x00000001L /* For slow interfaces */
#define	E1432_INSTALL_FASTER		0x00000002L /* For Slow interfaces */
#define	E1432_INSTALL_FASTEST		0x00000004L /* For SLOW interfaces */
#define	E1432_INSTALL_FROM_MEM		0x00000100L /* Not from file */
#define	E1432_INSTALL_DECOMPRESS	0x00000200L /* decompress before */
#define	E1432_INSTALL_SYSCALLS		0x08000000L /* Enable host syscalls */

/* e1432_read_raw_data */
/* e1432_read_float32_data */
/* e1432_read_float64_data */
/* The order of these determines the value of the 'type' bits in the
   info field of the trailer.  So don't change them without good
   reason. */
#define	E1432_TIME_DATA			345
#define	E1432_FREQ_DATA			346
#define	E1432_RESAMP_DATA		347
#define	E1432_ORDER_DATA		348
#define E1432_REQUEST_DATA              349
#define	E1432_USER1_DATA		350
#define	E1432_USER2_DATA		351
#define	E1432_OCTAVE_DATA		E1432_USER1_DATA

/* e1432_test_lbus */
#define	E1432_LBUS_TEST_LEFT		335
#define	E1432_LBUS_TEST_CENTER		336
#define	E1432_LBUS_TEST_RIGHT		337

/* e1432_write_srcbuffer_data */
/* When no input channels are active, an E143x module that has DRAM
   can use the DRAM to make a larger source buffer.  This also allows
   the maximum transfer size to be as large as the source buffer
   itself.  For this case, you can use
   E1432_SRC_DATA_NUMWORDS_MAX_DRAM as the maximum transfer size
   allowed for e1432_write_srcbuffer_data.

   If input channels are active, or there is no DRAM to use, then the
   transfer size for e1432_write_srcbuffer_data is limited to
   E1432_SRC_DATA_NUMWORDS_MAX, as it has always been. */
#define E1432_SRC_DATA_NUMWORDS_MAX_DRAM (E1432_DRAM_SIZE_MAX >> 2L)
#define E1432_SRC_DATA_NUMWORDS_MAX     4096

#define E1432_SRC_DATA_MODE_A           0x00000001
#define E1432_SRC_DATA_MODE_B           0x00000002
#define E1432_SRC_DATA_MODE_AB          0x00000003
#define E1432_SRC_DATA_MODE_WAITA       0x00000004
#define E1432_SRC_DATA_MODE_WAITB       0x00000005
#define E1432_SRC_DATA_MODE_WAITAB      0x00000006
#define E1432_SRC_DATA_MODE_RESETA      0x00000007
#define E1432_SRC_DATA_MODE_RESETB      0x00000008
#define	E1432_SRC_DATA_MODE_RAWDATA	0x00000009
#define	E1432_SRC_DATA_MODE_RAWCMD	0x0000000A
#define	E1432_SRC_DATA_MODE_RAWREAD	0x0000000B
#define	E1432_SRC_DATA_MODE_READSTATUS	0x0000000C
#define	E1432_SRC_DATA_MODE_READID	0x0000000D
#define	E1432_SRC_DATA_MODE_RAWNACKCMD	0x0000000E
#define	E1432_SRC_DATA_MODE_READNCLRSTATUS	0x0000000F

/* e1432_zap */
#define E1432_ZAP_BOOT                  1       /* Substrate BOOTROM */
#define E1432_ZAP_ID_CAL                2       /* Substrate ID/CAL constants */
#define E1432_ZAP_CLAR_ID_CAL           3       /* Clarinet ID/CAL constants */
#define E1432_ZAP_SRC12_ID_CAL		4       /* E1434 Ch 1 & 2 Id/cal */
#define E1432_ZAP_SRC34_ID_CAL		5       /* E1434 Ch 3 & 4 Id/cal */
#define E1432_ZAP_CLAR_BOOT		6       /* Clarinet code  */
#define E1432_ZAP_SRC12_BOOT		7       /* E1434 Ch 1 & 2 code  */
#define E1432_ZAP_SRC34_BOOT		8       /* E1434 Ch 3 & 4 code */
#define E1432_ZAP_SUBST_PARM2		9       /* Substrate FLASH PARM2 block */


/* Bit position defines in registers */

/* E1432_STATUS_REG */
#define	E1432_STATUS_CMD_READY		0x0001
#define	E1432_STATUS_Q_RESP_READY	0x0002
#define	E1432_STATUS_PASSED		0x0004
#define	E1432_STATUS_READY		0x0008
#define	E1432_STATUS_HW_OK		0x0010
#define	E1432_STATUS_UNUSED1		0x0020
#define	E1432_STATUS_ERR_N		0x0040
#define	E1432_STATUS_DONE		0x0080
#define	E1432_STATUS_LOADED		0x0100
#define	E1432_STATUS_ST_DONE		0x0200
#define	E1432_STATUS_DATA_READY		0x0400
#define	E1432_STATUS_BLOCK_READY	0x0800
#define	E1432_STATUS_UNUSED2		0x1000
#define	E1432_STATUS_UNUSED3		0x2000
#define	E1432_STATUS_MODID_N		0x4000
#define	E1432_STATUS_A24_ACTIVE		0x8000

/* E1432_CONTROL_REG */
#define	E1432_CONTROL_RESET_ON		0x0001
#define	E1432_CONTROL_RESET_OFF		0x0000
#define	E1432_CONTROL_SYSFAIL_INHIBIT_ON	0x0002
#define	E1432_CONTROL_SYSFAIL_INHIBIT_OFF	0x0000
#define	E1432_CONTROL_A24_ENABLE	0x8000

/* E1432_PORT_CTL_REG */
#define E1432_LBUS_DISABLE		0x0000
#define E1432_LBUS_ENABLE		0x0001
#define E1432_LBUS_PIPE			0x0003

/* E1432_MEAS_STATE_REG */
/* These must be in order, and must start with zero.  Also, DUMMY must follow
   CONVERT_WAIT2, and the ERROR states must be larger than the normal
   states. */
#define	E1432_MEAS_STATE_MASK		0x001f
#define	E1432_MEAS_STATE_TESTED		0x0000
#define	E1432_MEAS_STATE_BOOTING	0x0001
#define	E1432_MEAS_STATE_BOOTING_WAIT1	0x0002
#define	E1432_MEAS_STATE_BOOTING_WAIT2	0x0003
#define	E1432_MEAS_STATE_BOOTED		0x0004
#define	E1432_MEAS_STATE_SYNC		0x0005
#define	E1432_MEAS_STATE_SYNC_WAIT1	0x0006
#define	E1432_MEAS_STATE_PRE_ARM	0x0007
#define	E1432_MEAS_STATE_PRE_ARM_WAIT2	0x0008
#define	E1432_MEAS_STATE_IDLE		0x0009
#define	E1432_MEAS_STATE_ARM		0x000a
#define	E1432_MEAS_STATE_ARM_WAIT1	0x000b
#define	E1432_MEAS_STATE_ARM_WAIT2	0x000c
#define	E1432_MEAS_STATE_TRIGGER	0x000d
#define	E1432_MEAS_STATE_CONVERT	0x000e
#define	E1432_MEAS_STATE_CONVERT_WAIT1	0x000f
#define	E1432_MEAS_STATE_CONVERT_WAIT2	0x0010
#define	E1432_MEAS_STATE_DUMMY		0x0011
#define	E1432_MEAS_STATE_ERROR		0x0012
#define	E1432_MEAS_STATE_ERROR_WAIT1	0x0013
#define	E1432_MEAS_STATE_ERROR_WAIT2	0x0014
#define	E1432_MEAS_STATE_DUMMY2		0x0015
#define	E1432_MEAS_STATE_TPUT		0x0016
#define	E1432_MEAS_STATE_MAX		0x0017

/* E1432_IRQ_CONFIG_REG */
#define	E1432_IRQ_PRIORITY		0x0007
#define	E1432_IRQ_PRIORITY_NONE		0x0000
#define	E1432_IRQ_PRIORITY_MIN		0x0001
#define	E1432_IRQ_PRIORITY_MAX		0x0007
#define	E1432_IRQ_PRIORITY_DEF		E1432_IRQ_PRIORITY_NONE
#define	E1432_IRQ_ENABLE		0x0008
/* E1432_IRQ_STATUS_REG */
#define	E1432_IRQ_STATUS_LADDR_MASK	0x00ff
/* E1432_IRQ_CONFIG_REG, E1432_IRQ_STATUS_REG, and E1432_IRQ_STATUS2_REG */
#define	E1432_IRQ_MASK			0xff00
#define	E1432_IRQ_SHIFT			8
#define	E1432_IRQ_MEAS_WARNING		0x0100
#define	E1432_IRQ_BLOCK_READY		0x0200
#define	E1432_IRQ_MEAS_STATE_CHANGE	0x0400
#define	E1432_IRQ_TRIGGER		0x0800
#define	E1432_IRQ_OVERLOAD_CHANGE	0x1000
#define	E1432_IRQ_MEAS_ERROR		0x2000
#define	E1432_IRQ_TACHS_AVAIL		0x4000
#define E1432_IRQ_SRC_STATUS            0x8000
#define E1432_STATUS2_TACH_OVERFLOW	0x0001
#define	E1432_STATUS2_FIFO_EMPTIED	0x0002

/* E1432_SRC_STATUS_REG */
#define E1432_SRC_STATUS_UNDERRUN4      0x0001
#define E1432_SRC_STATUS_UNDERRUN2      0x0002
#define E1432_SRC_STATUS_UNDERRUN0      0x0004
#define E1432_SRC_STATUS_OVERREAD4      0x0008
#define E1432_SRC_STATUS_OVERREAD2      0x0010
#define E1432_SRC_STATUS_OVERREAD0      0x0020
#define	E1432_SRC_STATUS_SHUTDOWN4      0x0040
#define E1432_SRC_STATUS_SHUTDOWN2      0x0080
#define E1432_SRC_STATUS_SHUTDOWN0      0x0100
#define E1432_SRC_STATUS_OVERLOAD4      0x0200
#define E1432_SRC_STATUS_OVERLOAD2      0x0400
#define E1432_SRC_STATUS_OVERLOAD0      0x0800

/* e1432_selftest obsolete flags */
#define	E1432_SELFTEST_ALL_MODULES	0x0001
#define	E1432_SELFTEST_FAST		0x0002
#define	E1432_SELFTEST_LONG		0x0004

/* e1432_selftest() flags */
#define E1432_SELFTEST_VXI		0x0001 /* VXI interface */
#define E1432_SELFTEST_ASRAM		0x0002 /* substrate ASRAM */
#define E1432_SELFTEST_BSRAM		0x0004 /* substrate ASRAM */
#define E1432_SELFTEST_DSP		0x0008 /* 96002 */
#define E1432_SELFTEST_96K_HOSTPORT	0x0010 /* 96002 hostport */
#define E1432_SELFTEST_PLL		0x0020 /* substrate PLL */
#define E1432_SELFTEST_FLASH		0x0040 /* substrate FLASH PROM */
#define E1432_SELFTEST_MAIN		0x00ff /* all of the above */
#define E1432_SELFTEST_MAIN_IGNORE	0x0000 /* none of the above */

/* components, used internally */
#define E1432_SELFTEST_NON_DL		0x0001 /* non download testing */
#define E1432_SELFTEST_DL		0x0002 /* download testing */
#define E1432_SELFTEST_STD_IO		0x0004 /* std in, out testing */
/* packages, to be used externally */
#define E1432_SELFTEST_BASIC		0x0001 /* non download testing */
#define E1432_SELFTEST_FULL		0x0003 /* non and download testing */
#define E1432_SELFTEST_FULL_STD_IO	0x0007 /* both plus std in, out */

/* Bit position defines in the trailer structure.  The first four
   positions were chosen to work well with the Vibrato CSR register,
   so don't change them. */
#define	E1432_TRAILER_INFO_NOT_UNDERRANGE	0x00000001
#define	E1432_TRAILER_INFO_OVERLOAD		0x00000002
#define	E1432_TRAILER_INFO_OVERLOAD_COMM	0x00000004
#define	E1432_TRAILER_INFO_TRIGGER		0x00000008
#define	E1432_TRAILER_INFO_SETTLED		0x00000010
#define	E1432_TRAILER_INFO_STOP			0x00000020
#define	E1432_TRAILER_INFO_OT_RAMP_TOO_FAST	0x00000040
#define	E1432_TRAILER_INFO_EXTEND		0x00000080
#define	E1432_TRAILER_INFO_DEC_2_MASK		0x00001f00
#define	E1432_TRAILER_INFO_DEC_2_SHIFT		8
#define	E1432_TRAILER_INFO_DEC_5		0x00002000
#define	E1432_TRAILER_INFO_CHAN_MASK		0x03ff0000
#define	E1432_TRAILER_INFO_CHAN_SHIFT		16
#define	E1432_TRAILER_INFO_TYPE_MASK		0x1c000000
#define	E1432_TRAILER_INFO_TYPE_SHIFT		26

/* Structures */

struct e1432_hwconfig
{
    int     man_id;			/* VXI Manufacturer ID */
    int     model_code;			/* VXI Model code */
    long    hw_rev;			/* Hardware revision */
    long    bootrom_rev;		/* Bootrom revision */
    long    fw_rev;			/* Firmware revision */
    int     sca_id[E1432_SCAS];		/* What SCAs are present */
    long    sca_rev[E1432_SCAS];	/* SCA-specific revision */
    int     bob_id[E1432_SCAS];		/* What break-out boxes are present */
    int     total_chans;		/* Total channels available */
    int     input_chans;		/* Total input channels */
    int     source_chans;		/* Total source channels */
    int     tach_chans;			/* Total tach channels */
    int     oct_present;		/* octave option (1D1) installed */
    int     lbus_present;		/* Is local bus present */
    long    dram_size;			/* Total DRAM size, in 32-bit words */
    long    a24_used;			/* Bytes of A24 memory used */
    char    serial[E1432_SERIAL_LENGTH];/* Serial number */
};

struct e1432_install_from_mem
{
    long    nbyte;			/* Bytes to install */
    char   *data;			/* Pointer to install data */
};

struct e1432_trailer
{
    FLOATSIZ32 trig_corr;
    FLOATSIZ32 zoom_corr;
    FLOATSIZ32 rpm1;
    FLOATSIZ32 rpm2;
    LONGSIZ32 gap;
    LONGSIZ32 info;
    FLOATSIZ32 peak;
    FLOATSIZ32 rms;
};

typedef void * E1432ID;			/* Hardware ID pointer */

typedef struct e1432_diag_config
{
    SHORTSIZ16 valid;
    SHORTSIZ16 dram;
    SHORTSIZ16 scas[E1432_SCAS];
} E1432_DIAG_CONFIG;

/* Function prototypes */

/* Module setups */
extern SHORTSIZ16 EXPORT
e1432_get_append_status(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_append_status(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_arm_channel(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_arm_channel(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_arm_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_arm_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_arm_time_interval(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_arm_time_interval_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_arm_time_interval(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_auto_group_meas(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_auto_group_meas(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_auto_trigger(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_auto_trigger(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_avg_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_avg_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_avg_number(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_avg_number_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_avg_number(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_avg_update(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_avg_update_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_avg_update(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_avg_weight(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_avg_weight_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_avg_weight(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_blocksize(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_blocksize_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_blocksize(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_cal_dac(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_cal_dac_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			 FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_cal_dac(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_cal_voltage(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_cal_voltage_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_cal_voltage(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_calin(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_calin(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_center_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_center_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_center_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_clock_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_clock_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_clock_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_clock_master(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_clock_master(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_clock_source(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_clock_source(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_data_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_data_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_data_port(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_data_port(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_data_size(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_data_size(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_decimation_output(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_decimation_output(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_decimation_oversample(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_decimation_oversample(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_decimation_undersamp(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_decimation_undersamp_limits(E1432ID, SHORTSIZ16,
				      FLOATSIZ32 *, FLOATSIZ32 *,
				      FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_decimation_undersamp(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_delta_order(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_delta_order_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_delta_order(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_fifo_size(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_fifo_size_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_fifo_size(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_filter_settling_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_filter_settling_time_limits(E1432ID, SHORTSIZ16,
				      FLOATSIZ32 *, FLOATSIZ32 *,
				      FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_hpf_span(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_hpf_span_limits(E1432ID, SHORTSIZ16,
			  FLOATSIZ32 *, FLOATSIZ32 *,
			  FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_set_hpf_span(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_set_filter_settling_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_internal_debug(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_internal_debug_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_internal_debug(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_interrupt_mask(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_interrupt_mask(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_interrupt_priority(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_interrupt_priority_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_interrupt_priority(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_lbus_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_lbus_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_lbus_reset(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_reset_lbus(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_max_order(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_max_order_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_max_order(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_meas_time_length(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_meas_time_length_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				  FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_meas_time_length(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_mmf_delay(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_mmf_delay(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_multi_sync(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_multi_sync(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_octave_blocksize(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_avg_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_meas(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_octave_meas(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_avg_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_octave_hold_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_hold_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_octave_int_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_int_time_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			         FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_int_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_octave_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_octave_start_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_start_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			           FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_start_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_octave_stop_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_stop_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			          FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_stop_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_octave_time_const(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_time_const_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			           FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_time_const(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_octave_time_step(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_octave_time_step_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			              FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_octave_time_step(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_overlap(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_overlap_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			 FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_overlap(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_peak_decay_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_peak_decay_time_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_peak_decay_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_peak_hold_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_peak_hold_time_limits(E1432ID, SHORTSIZ16,
				FLOATSIZ32 *, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_set_peak_hold_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_peak_span(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_peak_span_limits(E1432ID, SHORTSIZ16,
			   FLOATSIZ32 *, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_set_peak_span(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_pre_arm_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_pre_arm_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_ramp(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ramp(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_rms_avg_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rms_avg_time_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rms_avg_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_rms_decay_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rms_decay_time_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rms_decay_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_rms_span(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_rms_span_limits(E1432ID, SHORTSIZ16,
			  FLOATSIZ32 *, FLOATSIZ32 *,
			  FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_set_rms_span(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_sample_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_sample_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_span(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_span_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
		      FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_span(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_sumbus(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_sumbus(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_delay(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_delay_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_delay(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_ext(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_ext(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_master(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_master(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_triggers_per_arm(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_triggers_per_arm_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				  FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_triggers_per_arm(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_ttltrg_clock(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ttltrg_clock(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_ttltrg_gclock(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ttltrg_gclock(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_ttltrg_satrg(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ttltrg_satrg(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_ttltrg_trigger(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ttltrg_trigger(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_window(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_window(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_xfer_size(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_xfer_size_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_xfer_size(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_zoom(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_zoom(E1432ID, SHORTSIZ16, SHORTSIZ16);

/* Channel setups */
extern SHORTSIZ16 EXPORT
e1432_get_active(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_active(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_amp_scale(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_amp_scale_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_amp_scale(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_anti_alias_analog(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_anti_alias_analog(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_anti_alias_digital(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_anti_alias_digital(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_arm_channel_per_input(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_set_arm_channel_per_input(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_auto_range_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_auto_range_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_calc_data(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_calc_data(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_coupling(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_coupling(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_coupling_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_coupling_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
		       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_coupling_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_duty_cycle(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_duty_cycle_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_duty_cycle(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_enable(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_enable(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_filter_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_filter_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_filter_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_input_high(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_input_high(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_input_low(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_input_low(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_input_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_input_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_input_offset(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_input_offset_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
		       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_input_offset(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_pre_arm_rpm(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_pre_arm_rpm_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_pre_arm_rpm(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_ramp_rate(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_ramp_rate_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_ramp_rate(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_range(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_range_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
		       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_range(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_range_charge(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_range_charge_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			      FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_range_charge(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_range_mike(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_range_mike_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_range_mike(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_high(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_high_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rpm_high(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_interval(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_interval_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rpm_interval(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_low(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_low_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rpm_low(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_smoothing(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_rpm_smoothing_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_rpm_smoothing(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_sine_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_sine_freq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_sine_freq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_sine_phase(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_sine_phase_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			    FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_sine_phase(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_source_blocksize(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_source_blocksize_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				  FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_blocksize(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_source_centerfreq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_source_centerfreq_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				   FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_centerfreq(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_source_cola(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_cola(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_source_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_source_output(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_output(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_source_seed(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_source_seed_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_seed(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_source_span(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_source_span_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			     FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_span(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_source_sum(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_source_sum(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_srcbuffer_init(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_srcbuffer_init(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_srcbuffer_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_srcbuffer_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_srcbuffer_size(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_srcbuffer_size_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_srcbuffer_size(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_srcparm_mode(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_srcparm_mode(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_srcoff_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_srcoff_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_tach_decimate(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_decimate_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_tach_decimate(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_tach_holdoff(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_holdoff_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			      FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_tach_holdoff(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_tach_irq_number(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_irq_number_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_tach_irq_number(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_tach_max_time(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_max_time_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			      FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_tach_max_time(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_tach_ppr(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_ppr_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
			  FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_tach_ppr(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_channel(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_channel(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_level(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ32*);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_level_limits(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ32 *,
			       FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_level(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_trigger_slope(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_trigger_slope(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_weighting(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_weighting(E1432ID, SHORTSIZ16, SHORTSIZ16);

/* Short cuts */
extern SHORTSIZ16 EXPORT
e1432_preset(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_set_analog_input(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16,
		       SHORTSIZ16, SHORTSIZ16, FLOATSIZ32);
extern SHORTSIZ16 EXPORT
e1432_set_data_format(E1432ID, SHORTSIZ16, LONGSIZ32,
		      SHORTSIZ16, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_set_interrupt(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_set_trigger(E1432ID, SHORTSIZ16, SHORTSIZ16, LONGSIZ32,
		  FLOATSIZ32, FLOATSIZ32, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_ttltrg_lines(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_ttltrg_lines(E1432ID, SHORTSIZ16, SHORTSIZ16);

/* Group setups */
extern SHORTSIZ16 EXPORT
e1432_assign_channel_numbers(SHORTSIZ16, SHORTSIZ16 *, E1432ID *);
extern SHORTSIZ16 EXPORT
e1432_assign_channels(SHORTSIZ16, SHORTSIZ16 *, E1432ID *, int);
extern SHORTSIZ16 EXPORT
e1432_channel_group_add(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_channel_group_remove(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_create_channel_group(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_delete_all_chan_groups(E1432ID);
extern SHORTSIZ16 EXPORT
e1432_delete_channel_group(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_fwrev(char *, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_group_info(E1432ID, SHORTSIZ16, SHORTSIZ16,
		     SHORTSIZ16 *, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_hwconfig(SHORTSIZ16, SHORTSIZ16 *, struct e1432_hwconfig *);
extern SHORTSIZ16 EXPORT
e1432_init_io_driver(void);
extern SHORTSIZ16 EXPORT
e1432_install_file(const char *, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_install(SHORTSIZ16, SHORTSIZ16 *, LONGSIZ32, const void *);
extern SHORTSIZ16 EXPORT
e1432_set_interface_addr(const char *);
extern SHORTSIZ16 EXPORT
e1432_uninit_io_driver(void);

/* Actions */
extern SHORTSIZ16 EXPORT
e1432_arm_measure(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_arm_measure_master_finish(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_arm_measure_master_setup(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_arm_measure_slave_finish(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_auto_range(E1432ID, SHORTSIZ16, FLOATSIZ64);
extern SHORTSIZ16 EXPORT
e1432_auto_zero(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_cached_parm_update(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_finish_measure(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_finish(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_master_finish(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_master_setup(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_slave_finish(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_slave_middle(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_slave_setup(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_init_measure_to_booted(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_octave_continue(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_octave_ctl(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_octave_restart(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_octave_stop(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_pre_arm_measure(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_read_i2c(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_reenable_interrupt(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_reset(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_reset_measure(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_test_lbus(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_trigger_measure(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_update_srcparm(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_write_i2c(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_zap(SHORTSIZ16, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_zap_src_boot(SHORTSIZ16, SHORTSIZ16, SHORTSIZ16, const char *);
extern SHORTSIZ16 EXPORT
i1432_read_serial(SHORTSIZ16, char *);
extern SHORTSIZ16 EXPORT
i1432_zap_parm2_opts(SHORTSIZ16, SHORTSIZ16, char *);
extern SHORTSIZ16 EXPORT
i1432_read_parm2_opts(SHORTSIZ16, char **, SHORTSIZ16 *);

/* Requested spectrum stuff */
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_check_spectrum(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_read_float32_spectrum(E1432ID, SHORTSIZ16, FLOATSIZ32 *, LONGSIZ32,
			    struct e1432_trailer *, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_read_float64_spectrum(E1432ID, SHORTSIZ16, FLOATSIZ64 *, LONGSIZ32,
			    struct e1432_trailer *, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_request_spectrum(E1432ID, SHORTSIZ16, FLOATSIZ32, LONGSIZ32,
		       LONGSIZ32, SHORTSIZ16, SHORTSIZ16);

/* Results */
extern SHORTSIZ16 EXPORT
e1432_check_overloads(E1432ID, SHORTSIZ16, SHORTSIZ16 *,
		      SHORTSIZ16 *, SHORTSIZ16 *, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_cvt_data(E1432ID, SHORTSIZ16, FLOATSIZ32 *, int);
extern SHORTSIZ16 EXPORT
e1432_get_raw_tachs(E1432ID, SHORTSIZ16, unsigned long *,
		    LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_float32_data(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ32 *,
			LONGSIZ32, struct e1432_trailer *,
			LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_float64_data(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ64 *,
			LONGSIZ32, struct e1432_trailer *,
			LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_raw_data(E1432ID, SHORTSIZ16, SHORTSIZ16, void *,
		    LONGSIZ32, struct e1432_trailer *, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_current_int32_data(E1432ID, SHORTSIZ16, SHORTSIZ16, LONGSIZ32 **,
                             LONGSIZ32 *); /* Not supported external to HP */
extern SHORTSIZ16 EXPORT
e1432_get_current_data(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16,
                       void **, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_samples_to_pre_arm(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_trig_corr(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_send_tachs(E1432ID, SHORTSIZ16, SHORTSIZ16,
		 unsigned long *, int, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_send_trigger(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_write_srcbuffer_data(E1432ID, SHORTSIZ16, LONGSIZ32 *, LONGSIZ32,
			   SHORTSIZ16);

/* General inquiry */
extern SHORTSIZ16 EXPORT
e1432_block_available(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_check_src_arbrdy(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_check_src_overload(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_check_src_overread(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_check_src_underrun(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_check_src_shutdown(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_blocksize_current_max(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_current_peak(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT /* E1432 option 204 only */
e1432_get_current_rms(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_current_rpm(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_data_rpm(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_decimation(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_fifo_size_current_max(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_meas_state(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_meas_warning(E1432ID, SHORTSIZ16, SHORTSIZ16 *,
		       unsigned long, unsigned long *);
extern SHORTSIZ16 EXPORT
e1432_get_next_arm_rpm(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_register_address(E1432ID, SHORTSIZ16, LONGSIZ32,
			   volatile SHORTSIZ16 **);
extern SHORTSIZ16 EXPORT
e1432_get_scale(E1432ID, SHORTSIZ16, FLOATSIZ64 *);
extern SHORTSIZ16 EXPORT
e1432_get_src_arbstates(E1432ID, SHORTSIZ16,LONGSIZ32 *, LONGSIZ32 *,
			LONGSIZ32 *, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_clock_freq(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_tach_delay(E1432ID, SHORTSIZ16, FLOATSIZ32 *);

/* Custom SCA */
extern SHORTSIZ16 EXPORT
e1432_sca_dsp_download(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_dsp_exec_query(E1432ID, SHORTSIZ16, LONGSIZ32,
		     LONGSIZ32, LONGSIZ32 *, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_src_rxfr(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_src_get_fwrev(LONGSIZ32 *, LONGSIZ32 *, LONGSIZ32 *, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_src_prog_romimage(E1432ID, SHORTSIZ16, LONGSIZ32 *, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_src_get_rev(E1432ID, SHORTSIZ16, LONGSIZ32 *, LONGSIZ32 *, LONGSIZ32 *, char *);

/* peak/rms/aux_fifo */
extern SHORTSIZ16 EXPORT
e1432_set_peak_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_peak_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_rms_mode(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_get_rms_mode(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_current_value(E1432ID, SHORTSIZ16, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_user_data(E1432ID, SHORTSIZ16, LONGSIZ32, SHORTSIZ16, SHORTSIZ16,
  SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_set_user_decimation(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_user_decimation(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_user_frames_per_block(E1432ID, SHORTSIZ16, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_get_user_frames_per_block(E1432ID, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_user_window(E1432ID, SHORTSIZ16, FLOATSIZ64 *, FLOATSIZ64);

/* Debugging setup */
extern void EXPORT
e1432_debug_level(SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_print_errors(SHORTSIZ16);
extern void EXPORT
e1432_set_try_recover(LONGSIZ32);
extern void EXPORT
e1432_trace_level(SHORTSIZ16);

/* Debugging */
extern SHORTSIZ16 EXPORT
e1432_display_state(E1432ID);
extern SHORTSIZ16 EXPORT
e1432_fill_error_string(char *, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_get_autozero_offset(E1432ID, SHORTSIZ16, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_get_autozero_offset_limits(E1432ID, SHORTSIZ16, FLOATSIZ32 *,
				 FLOATSIZ32 *, FLOATSIZ32 *, FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_set_autozero_offset(E1432ID, SHORTSIZ16, FLOATSIZ32);
extern char * EXPORT
e1432_get_error_string(void);
extern char * EXPORT
e1432_get_warning_string(SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_read_dsp_mem(E1432ID, SHORTSIZ16, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_dsp_port(E1432ID hw, SHORTSIZ16, SHORTSIZ16,
		    SHORTSIZ16 bytesPerWord, LONGSIZ32 dspAddr,
		    LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_flash(SHORTSIZ16, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_fw_marker(SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_read_register(E1432ID, SHORTSIZ16, LONGSIZ32, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_read32_register(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 EXPORT
e1432_write_dsp_mem(E1432ID, SHORTSIZ16, SHORTSIZ16, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16 EXPORT
e1432_write_dsp_port(E1432ID, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16,
		     LONGSIZ32, LONGSIZ32 dspData);
extern SHORTSIZ16 EXPORT
e1432_write_register(E1432ID, SHORTSIZ16, LONGSIZ32, SHORTSIZ16);
extern SHORTSIZ16 EXPORT
e1432_write32_register(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32);

/* selftest/diagnostics */
extern SHORTSIZ16 EXPORT
e1432_selftest(SHORTSIZ16, SHORTSIZ16 *, SHORTSIZ16, void *);
extern SHORTSIZ16 EXPORT
i1432_selftest(SHORTSIZ16, SHORTSIZ16, SHORTSIZ16, SHORTSIZ16 *, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_diag_print_level(SHORTSIZ16); /* Not supported external to HP */

/* Obsolete functions provided for Octane compatibility */
/* Use e1432_get_arm_mode and e1432_set_arm_mode to replace these: */
extern SHORTSIZ16 EXPORT
e1432_get_auto_arm(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_auto_arm(E1432ID, SHORTSIZ16, SHORTSIZ16);
/* Use e1432_get_span and e1432_set_span to replace these: */
extern SHORTSIZ16 EXPORT
e1432_get_decimation_bandwidth(E1432ID, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16 EXPORT
e1432_set_decimation_bandwidth(E1432ID, SHORTSIZ16, SHORTSIZ16);
/* Use e1432_set_decimation_output, e1432_set_anti_alias_digital, and
   e1432_set_span to replace this: */
extern SHORTSIZ16 EXPORT
e1432_set_decimation_filter(E1432ID, SHORTSIZ16, SHORTSIZ16,
			    SHORTSIZ16, SHORTSIZ16);

#ifdef __cplusplus
}
#endif

#endif	/* _E1432_H */
